using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ConsoleApplication1
{
    
    class TreeNode
    {
        public bool Posecen;

        public List<TreeNode> childern;
        TreeNode parent;

        public int N;
        public char Slovo;
        
        public TreeNode(int n, char slovo)
        {
            this.N = n;
            this.Slovo = slovo;
            this.childern = new List<TreeNode>();
            this.parent = null;
            Posecen = false;
        }

        public TreeNode(int n)
        {
            this.N = n;
            this.Slovo = '\n';
            this.childern = new List<TreeNode>();
            this.parent = null;
            Posecen = false;
        }

        public TreeNode()
        {
            this.N = -1;
            this.Slovo = '\n';
            this.childern = new List<TreeNode>();
            this.parent = null;
            Posecen = false;
        }
        
        public void addChild(int n, char slovo)
        {
            TreeNode child = new TreeNode(n, slovo);
            child.parent = this;
            this.childern.Add(child);
        }

        public bool Create(string[,] mat, int i, bool MozeObrnuto)
        {

            if (this.N == int.Parse(mat[i, 0]) || (MozeObrnuto && this.N == int.Parse(mat[i, 1])))
            {
                if (this.N == int.Parse(mat[i, 0]))
                    this.addChild(int.Parse(mat[i, 1]), mat[i, 2][0]);
                else
                    this.addChild(int.Parse(mat[i, 0]), mat[i, 2][0]);
                return true;
            }
            else
            {
                if (this.childern.Count > 0)
                {
                    for (int j = 0; j < this.childern.Count; j++)
                    {
                        if (this.childern[j].Create(mat, i, MozeObrnuto))
                            return true;

                    }
                }
                return false;
            }
            

        }


        public void CreateTree(string[,] mat, int l)
        {
            List<int> listaIzostavljenih = new List<int>();
            for (int i = 1; i < l; i++)
            {
                if (!this.Create(mat, i, false))
                    listaIzostavljenih.Add(i);
            }

            foreach (int i in listaIzostavljenih)
                this.Create(mat, i, true);
        }
    }


    class Program
    {
        static int BrojSioParova;
        static void Main(string[] args)
        {
            BrojSioParova = 0;
            int n = int.Parse(Console.ReadLine());
            string[,] mat = new string[n,3];

            for (int i = 0; i < n-1; i++)
            {
                string[] x = Console.ReadLine().Split(' ');
                mat[i, 0] = x[0];
                mat[i, 1] = x[1];
                mat[i, 2] = x[2];
            }

            int indexKorena = IndexKorena(mat, n);

            TreeNode koren = new TreeNode(int.Parse(mat[indexKorena,0]));
            koren.addChild(int.Parse(mat[indexKorena, 1]), mat[indexKorena, 2][0]);
            koren.CreateTree(mat, n-1);

            nSio(koren, 0, 0, 0, koren.N);

            Console.WriteLine(BrojSioParova);
            Console.Read();
        }

        static int IndexKorena(string[,] mat, int n)
        {
            int r = -1;
            for (int i = 0; i < n-1; i++)
            {
                r = i;
                for (int j = 0; j < n-1; j++)
                {
                    if (int.Parse(mat[j, 1]) == int.Parse(mat[i, 0]))
                    {
                        r = -1;
                        continue;
                    }
                }
                if (r != -1)
                    return r;
            }
            return 0;
        }

        static List<string> listaKoriscenih = new List<string>();
        static int[] nSio(TreeNode tn, int s, int i, int o, int u)
        {
            int S = s + (tn.Slovo == 'S' ? 1 : 0);
            int I = i + (tn.Slovo == 'I' ? 1 : 0);
            int O = o + (tn.Slovo == 'O' ? 1 : 0);

            if (S == I && I == O && S != 0)
            {
                if (!listaKoriscenih.Contains(u + "," + tn.N))
                {
                    BrojSioParova++;
                    Console.WriteLine(u + "," + tn.N);
                    listaKoriscenih.Add(u + "," + tn.N);
                    return new int[] { 0, 0, 0 };
                }
            }

            if (tn.childern.Count > 0)
                for (int j = 0; j < tn.childern.Count; j++)
                {
                    nSio(tn.childern[j], S, I, O, u);
                    nSio(tn.childern[j], 0, 0, 0, tn.N);

                }
            return new int[] { S, I, O };
        }
    }
}